<?php 

/**
*
* @package Free Tube Script
* @version v1.0
* @copyright (c) 2011 Agriz
* @license GNU Public License Under Certain Conditions [Powered by should remain unchanged]
* @contact http://www.agrizlive.com
*
*/

class Setting extends AppModel {

    var $name = 'Setting';
    var $key = 'MyApp';
    var $custom_settings = array();

    //retrieve configuration data from the DB
    function getcfg(){
        // get all settings from db
        $cfgs = $this->find('all', array('fields'=>array('id','key','value')));

        // if not is array we exit
        if( !is_array($cfgs) ) return;

        // parse each setting
        foreach($cfgs as $cfg) {

            // build the array for use later
            $data_array = array(
                        'id' =>    $cfg['Setting']['id'],
                        'key' => $cfg['Setting']['key'],
                        'value' => $cfg['Setting']['value'],
                        'checksum' => md5($cfg['Setting']['value']) );
            $this->custom_settings[] = $data_array;

            // write the config
            Configure::write($this->key . '.' . $cfg['Setting']['key'], $cfg['Setting']['value']);
        }	
    }
}